--mounting 3d model paths and texture paths 

mount_vfs_model_path (current_mod_path.."/Shapes")
mount_vfs_texture_path (current_mod_path.."/TempTextures")
mount_vfs_liveries_path (current_mod_path.."/Liveries")
mount_vfs_texture_path("Bazar/World/textures/")
mount_vfs_texture_path  (current_mod_path.."/Textures")
mount_vfs_texture_path  (current_mod_path.."/Textures/Avionics")
mount_vfs_texture_path("Bazar/World/textures/CockpitsHDTextures")
mount_vfs_texture_path  (current_mod_path.."/Textures/M2000.zip")
mount_vfs_texture_path  (current_mod_path.."/Textures/Textures_Cockpit_Mirage2000C.zip")

Mirage_2000C =  {
        
	Name 				=   'Mirage2000C',
	DisplayName			= _('Mirage2000C'),
	
	HumanCockpit 		= true,
	HumanCockpitPath    = current_mod_path..'/Cockpit/',
	
	Picture 			= "Mirage_2000-5.png",
	Rate 				= 40, -- RewardPoint in Multiplayer
	Shape 				= "m2000",
	
	shape_table_data 	= 
	{
		{
			file  	 = 'm2000';
			life  	 = 20; -- lifebar
			vis   	 = 3; -- visibility gain.
			desrt    = 'm2000'; -- Name of destroyed object file name
			fire  	 = { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username = 'Mirage2000C';
			index    =  WSTYPE_PLACEHOLDER;
		},
		{
			name  = "m2000-oblomok";
			file  = "m2000-oblomok";
			fire  = { 240, 2};
		},

	},
	mapclasskey 		= "P0091000025",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER ,"Battleplanes",},
	Categories 			= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},	
	-------------------------
	M_empty 					= 7800, -- kg
	M_nominal 					= 9525, -- kg
	M_max 						= 16500, -- kg
	M_fuel_max 					= 3200, -- kg --2225
	H_max 					 	= 16460, -- m
	average_fuel_consumption 	= 0.07, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	CAS_min 					= 52, -- if this is not OVERAL FLIGHT TIME, but jus LOITER TIME, than it sholud be 10-15 minutes.....CAS capability in minute (for AI)
	V_opt 						= 170,-- Cruise speed (for AI)
	V_take_off 					= 64, -- Take off speed in m/s (for AI)
	V_land 						= 64, -- Land speed in m/s (for AI)
	V_max_sea_level 				= 403, -- Max speed at sea level in m/s (for AI)
	V_max_h 					= 660, -- Max speed at max altitude in m/s (for AI)
	Vy_max 						= 315.3, -- Max climb speed in m/s (for AI)
	Mach_max 					= 2.3, -- Max speed in Mach (for AI)
	Ny_min 						= -3.2, -- Min G (for AI)
	Ny_max 						= 9,  -- Max G (for AI)
	Ny_max_e 					= 9,  -- Max G (for AI)
	AOA_take_off 				= 0.14, -- AoA in take off (for AI)
	bank_angle_max 				= 60, -- Max bank angle (for AI)


	has_afteburner 				= true, -- AFB yes/no
	has_speedbrake 				= true, -- Speedbrake yes/no
	nose_gear_pos 				= 	{3.924,	-1.746,	0},  
	main_gear_pos 				= 	{-1.121, -1.748, 1.751},
	tand_gear_max 				= 0.577,
	tanker_type 				= 0, -- Tanker type if the plane is airrefuel capable
	wing_area 					= 41, -- wing area in m2
	wing_span 					= 9.13, -- wing spain in m
	wing_type 					= 0,
	thrust_sum_max 				= 6430, -- thrust in kg (44kN)
	thrust_sum_ab 				= 9810, -- thrust inkg (71kN)
	length 						= 14.6, -- full lenght in m
	height 						= 5.2, -- height in m
	flaps_maneuver 				= 0.5, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
	range 						= 1852, -- Max range in km (for AI)
	RCS 						= 5, -- Radar Cross Section m2
	IR_emission_coeff 			= 0.8, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
	IR_emission_coeff_ab 		= 3, -- With afterburner
	wing_tip_pos 				=  {-4.372, -0.435, 4.583}, -- wingtip coords for visual effects
	nose_gear_wheel_diameter 	= 0.754, -- in m
	main_gear_wheel_diameter 	= 0.972, -- in m
	main_gear_amortizer_direct_stroke	 	 =   0.1, --  down from main_gear_pos !!!
	main_gear_amortizer_reversal_stroke  	 = 	-0.15, --  up 
	main_gear_amortizer_normal_weight_stroke =  0.0,-- down from main_gear_pos
	nose_gear_amortizer_direct_stroke   		=  0.13,  -- down from nose_gear_pos !!!
	nose_gear_amortizer_reversal_stroke  		= -0.03,  -- up 
	nose_gear_amortizer_normal_weight_stroke 	= 0.0,   -- up 
	brakeshute_name 			= 5, -- Landing - brake chute visual shape after separation
	is_tanker 					= false, -- Tanker yes/no
	air_refuel_receptacle_pos 	= {5.928,	0.885,	0.521}, -- refuel coords
	engines_count				= 2, -- Engines count
	engines_nozzles = {
		[1] = 
		{
			pos = 	{-6.63,	0.401,	0},
				elevation	=	0,
				diameter	=	0.9,
				exhaust_length_ab	=	6.8,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.05, 
		}, -- end of [1]

	}, -- end of engines_nozzles
	crew_size	 = 1,
	crew_members = 
	{
		[1] = 
		{
			ejection_seat_name = "9",
			drop_canopy_name = "40",
			pos =  {3.369,	-0.146,	0},
			canopy_pos = {3.369,	-0.146,	0},
		}, -- end of [1]
	}, -- end of crew_members

	fires_pos = 
		{
			[1] = 	{-2.117,	-0.9,	0},
			[2] = 	{-1.584,	0.176,	2.693},
			[3] = 	{-1.645,	0.213,	-2.182},
			[4] = 	{-0.82,	0.265,	2.774},
			[5] = 	{-0.82,	0.265,	-2.774},
			[6] = 	{-0.82,	0.255,	4.274},
			[7] = 	{-0.82,	0.255,	-4.274},
			[8] = 	{-6.548,	-0.248,	0},
			[9] = 	{-6.548,	-0.248,	0},
			[10] = 	{0.304,	-0.748,	0.442},
			[11] = 	{0.304,	-0.748,	-0.442},
		}, -- end of fires_pos
	
	
	-- Countermeasures
	SingleChargeTotal	 	= 128,
	CMDS_Incrementation 	= 4,
	ChaffDefault 			= 112, 
	ChaffChargeSize 		= 1,
	FlareDefault 			= 16, 
	FlareChargeSize 		= 1,
	CMDS_Edit 				= true,
	chaff_flare_dispenser 	= {
		[1] = 
		{
			dir =  {0, -0.2, 0},
			pos =  {-1.385,	-0.7,	0.5},
		}, 		[2] = 
		{
			dir =  {0, -0.2, 0},
			pos =  {-1.385,	-0.7,	-0.5},
		}, -- end of [2]-- end of [1]

	}, -- end of chaff_flare_dispenser

	--sensors
	
	detection_range_max		 = 60,
	radar_can_see_ground 	 = false, -- this should be examined (what is this exactly?)
	CanopyGeometry = {
		azimuth   = {-160.0, 160.0}, -- pilot view horizontal (AI)
		elevation = {-50.0, 90.0} -- pilot view vertical (AI)
	},
	Sensors = {
		RWR = "Abstract RWR", -- RWR type
		RADAR = "N-019", -- Radar type
	},
	HumanRadio = {
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},
	
	
Guns =  {
         gun_mount("DEFA_554", { count = 125 },{muzzle_pos = {1.019, -0.463,-0.31}}),
         gun_mount("DEFA_554", { count = 125 },{muzzle_pos = {1.019, -0.463, 0.31}})
        },		 
	
	Pylons =     {

         pylon(1, 0, -2.451000, -0.614000, -3.210000,
            {
            },
            {
                { CLSID = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" },
            }
        ),
        pylon(2, 0, -1.1000, -0.612000, -2.340000,
            {
            },
            {
	{ CLSID = "{E1F29B21-F291-4589-9FD8-3272EEC69506}"},--Fuel tank 610 gal  F15-PTB
                { CLSID = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}" },
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}" },
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}" },
                { CLSID = "{414DA830-B61A-4F9E-B71B-C2F6832E1D7A}" },
            }
        ),
        pylon(3, 0, 1.048000, -0.543000, -0.802000,
            {
            },
            {
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}" },
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}" },
            }
        ),
        pylon(4, 0, -3.072000, -0.543000, -0.802000,
            {
            },
            {
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}" },
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}" },
            }
        ),
        pylon(5, 0, -0.975000, -0.810000, 0.000000,
            {
            },
            {
                { CLSID = "{414DA830-B61A-4F9E-B71B-C2F6832E1D7A}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" },
            }
        ),
        pylon(6, 0, -3.072000, -0.543000, 0.802000,
            {
            },
            {
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}" },
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}" },
            }
        ),
        pylon(7, 0, 1.048000, -0.543000, 0.802000,
            {
            },
            {
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}" },
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}" },
            }
        ),
        pylon(8, 0, -1.1000, -0.612000, 2.340000,
            {
            },
            {
	{ CLSID = "{E1F29B21-F291-4589-9FD8-3272EEC69506}"},--Fuel tank 610 gal  F15-PTB
                { CLSID = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}" },
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}" },
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}" },
                { CLSID = "{414DA830-B61A-4F9E-B71B-C2F6832E1D7A}" },
            }
        ),
        pylon(9, 0, -2.451000, -0.614000, 3.210000,
            {
            },
            {
                { CLSID = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" },
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" },
            }
        ),
        
},	
	
	Tasks = {
	aircraft_task(CAP),
        aircraft_task(Escort),
        aircraft_task(FighterSweep),
        aircraft_task(Intercept),
    },	
	DefaultTask = aircraft_task(CAP),
	
	SFM_Data = {
		aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
		{
			Cy0			=	0,      -- zero AoA lift coefficient
			Mzalfa		=	6.6,  -- coefficients for pitch agility
			Mzalfadt	=	1,    -- coefficients for pitch agility
			kjx			=	2.95,    
			kjz			=	0.00130, 
			Czbe		=	-0.016, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
			cx_gear		=	0.0218,    -- coefficient, drag, gear
			cx_flap		=	0.05,   -- coefficient, drag, full flaps
			cy_flap		=	0.06,    -- coefficient, normal force, lift, flaps
			cx_brk		=	0.08,   -- coefficient, drag, breaks
			table_data  = 
			{	--      M	Cx0 	Cya	B	B4		Omxmax	Aldop	Cymax
				[1] = 	{0.0,	0.010,	0.07,	0.190,	0.001,		0.87,	22.0,	1.80},
				[2] = 	{0.2,	0.012,	0.07,	0.190,	0.001,		2.02,	21.0,	1.80},
				[3] = 	{0.4,	0.015,	0.07,	0.195,	0.001,		3.20,	20.5,	1.80},
				[4] = 	{0.5,	0.018,	0.073,	0.195,	0.001,		4.20,	19.0,	1.75},
				[5] = 	{0.6,	0.019,	0.076,	0.198,	0.0015,		5.00,	18.0,	1.70},
				[6] = 	{0.7,	0.020,	0.079,	0.190,	0.0015,		5.50,	17.0,	1.60},
				[7] = 	{0.8,	0.021,	0.083,	0.200,	0.0015,		5.80,	16.0,	1.50},
				[8] = 	{0.9,	0.022,	0.085,	0.250,	0.002,		6.00,	14.5,	1.40},
				[9] = 	{1.0,	0.023,	0.0855,	0.300,	0.002,		5.90,	13.5,	1.30},
				[10] = 	{1.1,	0.025,	0.086,	0.350,	0.002,		5.40,	12.5,	1.20},
				[11] = 	{1.2,	0.028,	0.083,	0.370,	0.002,		5.20,	11.0,	1.00},
				[12] = 	{1.3,	0.030,	0.077,	0.400,	0.002,		5.00,	10.0,	0.80},
				[13] = 	{1.4,	0.030,	0.062,	0.420,	0.002,		4.80,	9.5,	0.50},
				[14] = 	{1.5,	0.030,	0.0513,	0.440,	0.002,		4.60,	9.0,	0.45},
				[15] = 	{1.6,	0.030,	0.046,	0.460,	0.003,		4.30,	8.5,	0.40},
				[16] = 	{1.8,	0.030,	0.039,	0.570,	0.004,		4.00,	7.0,	0.35},
				[17] = 	{2.0,	0.030,	0.034,	0.575,	0.005,		3.70,	6.5,	0.30},
				[18] = 	{2.2,	0.030,	0.033,	0.580,	0.006,		3.00,	5.0,	0.25},
				[19] = 	{2.5,	0.060,	0.033,	0.682,	0.007,		2.50,	5.0,	0.22},
				[20] = 	{3.9,	0.060,	0.033,	0.684,	0.008,		1.00,	5.0,	0.20},
			}, -- end of table_data
			-- M - Mach number
			-- Cx0 - Coefficient, drag, profile, of the airplane
			-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
			-- B - Polar quad coeff
			-- B4 - Polar 4th power coeff
			-- Omxmax - roll rate, rad/s
			-- Aldop - Alfadop Max AOA at current M - departure threshold
			-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	65, -- RPM at idle
			MinRUD	=	0, -- Min state of the throttle
			MaxRUD	=	1, -- Max state of the throttle
			MaksRUD	=	0.75, -- Military power state of the throttle
			ForsRUD	=	0.90, -- Afterburner state of the throttle
			typeng	=	1,
			--[[
				E_TURBOJET = 0
				E_TURBOJET_AB = 1
				E_PISTON = 2
				E_TURBOPROP = 3
				E_TURBOFAN = 4
				E_TURBOSHAFT = 5
			--]]
			
			hMaxEng	=	19.5, -- Max altitude for safe engine operation in km
			dcx_eng	=	0.0085, -- Engine drag coeficient
			cemax	=	1.24, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			cefor	=	2.56, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			dpdh_m	=	4100, --  altitude coefficient for max thrust
			dpdh_f	=	11800,  --  altitude coefficient for AB thrust
			table_data = 
			{	    --   M	Pmax	 Pfor	
				[1] = 	{0,	70000,	98000},
				[2] = 	{0.2,	70000,	99900},
				[3] = 	{0.4,	68500,	99900},
				[4] = 	{0.6,	67500,	109300},
				[5] = 	{0.7,	67500,	120300},
				[6] = 	{0.8,	67500,	130300},
				[7] = 	{0.9,	68500,	145300},
				[8] = 	{1,	70600,	168300},
				[9] = 	{1.1,	75600,	177300},
				[10] = 	{1.2,	80600,	188300},
				[11] = 	{1.3,	82600,	197300},
				[12] = 	{1.5,	76600,	206300},
				[13] = 	{1.8,	69846,	202300},
				[14] = 	{2,	72319,	196300},
				[15] = 	{2.2,	71083,	151300},
				[16] = 	{2.5,	68609,	116300},
				[17] = 	{3,	62027,	106436},
			}, -- end of table_data
			-- M - Mach number
			-- Pmax - Engine thrust at military power
			-- Pfor - Engine thrust at AFB
		}, -- end of engine
	},
	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
				[0]		= {critical_damage = 5, args = {146}},
				[3]		= {critical_damage = 20,args = {65}}  ,
				[4]		= {critical_damage = 20, args = {150}},
				[5]		= {critical_damage = 20, args = {147}},
				[7]		= {critical_damage = 4, args = {249}} ,
				[9]		= {critical_damage = 3, args = {154}},
				[10]	= {critical_damage = 3, args = {153}},
				[11]	= {critical_damage = 3, args = {167}},
				[12]	= {critical_damage = 3, args = {161}},
				[15]	= {critical_damage = 5, args = {267}},
				[16]	= {critical_damage = 5, args = {266}},
				[23]	= {critical_damage = 8, args = {223}, deps_cells = {25}},
				[24]	= {critical_damage = 8, args = {213}, deps_cells = {26, 60}},
				[25]	= {critical_damage = 3, args = {226}},
				[26]	= {critical_damage = 3, args = {216}},
				[29]	= {critical_damage = 9, args = {224}, deps_cells = {31, 25, 23}},
				[30]	= {critical_damage = 9, args = {214}, deps_cells = {32, 26, 24, 60}},
				[31]	= {critical_damage = 4, args = {229}},
				[32]	= {critical_damage = 4, args = {219}},
				[35]	= {critical_damage = 10, args = {225}, deps_cells = {29, 31, 25, 23}},
				[36]	= {critical_damage = 10, args = {215}, deps_cells = {30, 32, 26, 24, 60}} ,
				[37]	= {critical_damage = 4, args = {227}},
				[38]	= {critical_damage = 4, args = {217}},
				[39]	= {critical_damage = 7,	args = {244}, deps_cells = {53}},
				[40]	= {critical_damage = 7, args = {241}, deps_cells = {54}},
				[45]	= {critical_damage = 9, args = {235}, deps_cells = {39, 51, 53}},
				[46]	= {critical_damage = 9, args = {233}, deps_cells = {40, 52, 54}},
				[51]	= {critical_damage = 3, args = {239}},
				[52]	= {critical_damage = 3, args = {237}},
				[53]	= {critical_damage = 3, args = {248}},
				[54]	= {critical_damage = 3, args = {247}},
				[55]	= {critical_damage = 20, args = {81}, deps_cells = {39, 40, 45, 46, 51, 52, 53, 54}},
				[59]	= {critical_damage = 5, args = {148}},
				[60]	= {critical_damage = 1, args = {144}},

				[83]	= {critical_damage = 3, args = {134}} ,-- nose wheel
				[84]	= {critical_damage = 3, args = {136}}, -- left wheel
				[85]	= {critical_damage = 3, args = {135}} ,-- right wheel
	},
	
	DamageParts = 
	{  
		[1] = "m2000-oblomok-wing-r", -- wing R
		[2] = "m2000-oblomok-wing-l", -- wing L
		[3] = "Wunderluft-part-nose", -- nose
		[4] = "Wunderluft-part-tail", -- tail
	},
	
	lights_data = {
	typename = "collection",
	lights = {
    [1] = { typename = "collection",
						lights = {-- Left Anticollision Light
								  {typename = "natostrobelight",
								   connector = "WHITE_BEACON L",
								   argument_1 = 195,
								   period = 1.2,
								   phase_shift = 0
								  },
								  -- Right Anticollision Light
								  {typename = "natostrobelight",
								   connector = "WHITE_BEACON R",
								   argument_1 = 196,
								   period = 1.2,
								   phase_shift = 0
								  },
								  -- Tail Anticollision Light
								  {typename = "natostrobelight",
								   connector = "BANO_0_BACK",
								   argument_1 = 192,
								   period = 1.2,
								   phase_shift = 0
								  }
								 }
									  },
	[2] = { typename = "collection",
							lights = {-- Landing light
									  {typename = "spotlight",
									   connector = "MAIN_SPOT_PTR_02",
									   argument = 209,
									   dir_correction = {elevation = math.rad(-1)}
									  },
									  {-- Landing/Taxi light
									   typename = "spotlight",
									   connector = "MAIN_SPOT_PTR_01",
									   argument = 208,
									   dir_correction = {elevation = math.rad(3)}
									  }
									 }
						},
    [3]	= {	typename = "collection",
								lights = {-- Left Position Light (red)
								{typename = "omnilight",
								 connector = "BANO_1",
								 color = {0.99, 0.11, 0.3},
								 pos_correction  = {0.1, 0, -0.2},
								 argument  = 190
								},
								 -- Right Position Light (green)
								{typename = "omnilight",
								connector = "BANO_2",
								color = {0, 0.894, 0.6},
								pos_correction = {0.1, 0, 0.2},
								argument  = 191
								},
								-- Tail Position Light (white)
								{typename = "omnilight",
								connector = "BANO_0",
								color = {1, 1, 1},
								pos_correction  = {0, 0, 0},
								argument  = 192
								}}
							},
--[4] = { typename = "collection", -- white strobe upper
--	lights = {
--				{typename = "natostrobelight",connector = "WHITE_TOP",argument_1 = 999,period = 1.0,color = {0.8, 0.8, 1.0},phase_shift = 0.0},
--				{typename = "natostrobelight",connector = "WHITE_TOP",argument_1 = 998,period = 1.0,color = {0.8, 0.8, 1.0},phase_shift = 0.5},
--			 }
--		},
	[5]	= {typename = "collection",
			lights = {
						{typename = "collection",
						lights = {{
								-- Right Nacelle Floodlight
								typename = "spotlight",
								position  = {0.5, 1.2, 0},
								color = {1.0, 1.0, 1.0},
								intensity_max = 0.0,
								angle_max = 0.45,
								direction = {azimuth = math.rad(150), elevation = math.rad(5)},
								dont_change_color = false,
								angle_change_rate = 0
							   },
							   {
								-- Left Nacelle Floodlight
								typename = "spotlight",
								position  = {0.5, 1.2, 0},
								color = {1.0, 1.0, 1.0},
								intensity_max = 0.0,
								angle_max = 0.45,
								direction = {azimuth = math.rad(-150), elevation = math.rad(5)},
								dont_change_color = false,
								angle_change_rate = 0
							   },
							   {typename  = "argumentlight", argument = 212},
						},
					},
					{typename = "collection",
						lights = {{
								-- Left Nose Floodlight
								typename  = "spotlight",
								position  = {0, -0.3, -5.80},
								color = {1.0, 1.0, 1.0},
								intensity_max = 0.0, angle_max = 0.45,
								direction = {azimuth = math.rad(45)},
								argument = 211,
								dont_change_color = false,
								angle_change_rate = 0
							   },
							   {
								-- Right Nose Floodlight
								typename = "spotlight",
								position  = {0, -0.3, 5.80},
								color = {1.0, 1.0, 1.0},
								intensity_max = 0.0,
								angle_max = 0.45,
								direction = {azimuth = math.rad(-45)},
								argument = 210,
								dont_change_color = false,
								angle_change_rate = 0
							   }
						}
					},
					-- UARRSI light
					{
						typename = "omnilight", position  = {6.5, 0.4, 0}, color = {6, 6, 2}
					}
				  },
			}
		}
	},
	Countries = {"France"},
}

add_aircraft(Mirage_2000C)
